//  Copyright 2019 mobileknowledge. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "ISO15693Command.h"
#import "NTAG5Strings.h"
#import "NTAG5_NFC_LIB.h"
#import "RFCommands.h"

NS_ASSUME_NONNULL_BEGIN

@interface GPIOUseCase: NSObject

+ (GPIOUseCase *) sharedInstance;

/*!
 *@abstract   reads GPIO config and registers
 **/
- (void) readGPIO:(void (^)(NSData *aData, const int order) )success  onFailure : (void(^)(NSError *error))failure;

/*!
 *@abstract   gets GPIO Input status
 **/
- (void) getGPIOInput:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure;

/*!
 *@abstract   Clears GPIO Output and turns the LED off
 **/
- (void) clearGPIOOutput:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure;

/*!
 *@abstract   pushes GPIO Output and turns the LED on
 **/
- (void) pushGPIOOutput:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure;

/*!
 *@abstract   writes to GPIO config and session registers
 **/
- (void) writeGPIO: (ISO15693Command *)getTagConfig getTagConfig: (ISO15693Command *) getTagSession onSuccess:(void (^)(NSData *aData))success  onFailure : (void(^)(NSError *error))failure;

@end

NS_ASSUME_NONNULL_END
